/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.python.core.PyObject;
import org.python.util.Generic;

public class IdImpl {
    private WeakIdentityMap idMap = new WeakIdentityMap();
    private long sequentialId;

    public synchronized long id(PyObject pyObject) {
        Object object = pyObject.getJavaProxy();
        if (object != null) {
            return this.java_obj_id(object);
        }
        return this.java_obj_id(pyObject);
    }

    public String idstr(PyObject pyObject) {
        return String.format("0x%x", this.id(pyObject));
    }

    public synchronized long java_obj_id(Object object) {
        Long l = (Long)this.idMap.get(object);
        if (l == null) {
            long l2 = ++this.sequentialId;
            this.idMap.put(object, l2);
            return l2;
        }
        return l;
    }

    public static class WeakIdentityMap {
        private transient ReferenceQueue<Object> idKeys = new ReferenceQueue();
        private Map<WeakIdKey, Object> objHashcodeToPyId = Generic.map();

        private void cleanup() {
            Reference<Object> reference;
            while ((reference = this.idKeys.poll()) != null) {
                this.objHashcodeToPyId.remove(reference);
            }
        }

        public int _internal_map_size() {
            return this.objHashcodeToPyId.size();
        }

        public void put(Object object, Object object2) {
            this.cleanup();
            this.objHashcodeToPyId.put(new WeakIdKey(object), object2);
        }

        public Object get(Object object) {
            this.cleanup();
            return this.objHashcodeToPyId.get(new WeakIdKey(object));
        }

        public void remove(Object object) {
            this.cleanup();
            this.objHashcodeToPyId.remove(new WeakIdKey(object));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class WeakIdKey
        extends WeakReference<Object> {
            private final int hashcode;

            WeakIdKey(Object object) {
                super(object, WeakIdentityMap.this.idKeys);
                this.hashcode = System.identityHashCode(object);
            }

            public int hashCode() {
                return this.hashcode;
            }

            public boolean equals(Object object) {
                Object t = this.get();
                if (t != null) {
                    return t == ((WeakIdKey)object).get();
                }
                return this == object;
            }
        }
    }
}

